/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.attn.np;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.attn.Attention;
import com.ibm.hwmca.fw.attn.AttentionID;
import com.ibm.hwmca.fw.attn.np.AttentionConstants;
import com.ibm.hwmca.fw.attn.np.AttentionCoreInfo;
import com.ibm.hwmca.fw.attn.np.AttentionRequest;
import com.ibm.hwmca.fw.attn.np.AttentionTaskletManager;
import com.ibm.hwmca.fw.attn.np.HwMessagesBean;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class AttentionPanelTasklet
extends PanelTasklet
implements PropertyChangeListener {
    private static final String TRACE_MASKT = "XEMP006T";
    private static final String TRACE_MASKF = "XEMP006F";
    private static final String TRACE_MASKD = "XEMP006D";
    private static final String frameBeanName = "Hardware Messages";
    private FrameBean frameBean = new FrameBean("Hardware Messages");
    private HashMap inventory = new HashMap();
    private Object inventoryLock = new Object();
    private ArrayList pendingTabRemovals = new ArrayList();
    private Object pendingTabRemovalsLock = new Object();
    private ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
    private HMC hmc = HMC.getHMC();
    private boolean primaryTasklet = false;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObjectManager;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;

    public AttentionPanelTasklet() {
        Trace.trace(TRACE_MASKT, ">> AttentionPanelTasklet()");
        Trace.trace(TRACE_MASKT, "<< AttentionPanelTasklet()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> service()");
        this.dumpInventory();
        if (request.isCanceled() || request.isDisposed()) {
            this.processTaskShutdown(request, response);
        } else if (request.isInitialRequest()) {
            this.processInitialRequest(request, response);
        } else {
            String source = (String)request.getData("SOURCE");
            String action = (String)request.getData("ACTION");
            Trace.trace(TRACE_MASKF, "   Source = " + source);
            Trace.trace(TRACE_MASKF, "   Action = " + action);
            if (source.equals("SERVER")) {
                this.processServerRequest(request, response);
            } else if (action.equals("DELETE")) {
                this.processDeleteRequest(request, response);
            } else if (action.equals("DETAILS")) {
                this.processDetailsRequest(request, response);
            } else {
                Trace.trace(TRACE_MASKF, "   Unknown request received...");
                new FrameworkLog(AttentionConstants.LOGINFO, 3, new HException("Unknown request")).log(FrameworkLogAttributes.INFO_LOG);
            }
        }
        this.dumpInventory();
        Trace.trace(TRACE_MASKT, "<< service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, ">> logException()");
        this.cleanup();
        new FrameworkLog(AttentionConstants.LOGINFO, 3, throwable).log(FrameworkLogAttributes.INFO_LOG);
        Trace.trace(TRACE_MASKT, "<< logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInventory() {
        HashMap current = new HashMap();
        Object object = this.inventoryLock;
        synchronized (object) {
            Iterator iterator = this.inventory.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                current.put(entry.getKey(), entry.getValue());
            }
        }
        Trace.trace(TRACE_MASKD, "   Current tab inventory : " + current.size() + " entries");
        if (!current.isEmpty()) {
            Iterator iterator = current.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Trace.trace(TRACE_MASKD, "      " + entry.getKey() + " : " + entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent event) {
        block16: {
            Trace.trace(TRACE_MASKT, ">> propertyChange()");
            ObjectId source = (ObjectId)event.getSource();
            Trace.trace(TRACE_MASKF, "   Source    = " + source);
            Trace.trace(TRACE_MASKF, "   Property  = " + event.getPropertyName());
            Trace.trace(TRACE_MASKF, "   Old Value = " + event.getOldValue());
            Trace.trace(TRACE_MASKF, "   New Value = " + event.getNewValue());
            if (source.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectManager == null ? (class$com$ibm$hwmca$fw$managed$ManagedObjectManager = AttentionPanelTasklet.class$("com.ibm.hwmca.fw.managed.ManagedObjectManager")) : class$com$ibm$hwmca$fw$managed$ManagedObjectManager)) {
                Object[] removed = (Object[])event.getOldValue();
                if (removed != null && removed.length > 0) {
                    Object object = this.pendingTabRemovalsLock;
                    synchronized (object) {
                        this.pendingTabRemovals.addAll(Arrays.asList(removed));
                    }
                    AttentionRequest request = new AttentionRequest("SERVER", "REMOVE_TABS", null, null);
                    try {
                        this.postRequest(this.frameBean.getBeanName(), request);
                    }
                    catch (TaskletException exception) {
                        Trace.trace(TRACE_MASKF, exception);
                        new FrameworkLog(AttentionConstants.LOGINFO, 3, new HException(exception)).log(FrameworkLogAttributes.INFO_LOG);
                        this.abnormalTerminate();
                    }
                }
            } else if (source.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = AttentionPanelTasklet.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject)) {
                AttentionRequest request = new AttentionRequest("SERVER", "REFRESH", source, null);
                try {
                    String name = null;
                    Object object = this.inventoryLock;
                    synchronized (object) {
                        name = (String)this.inventory.get(source);
                    }
                    if (name != null) {
                        Trace.trace(TRACE_MASKF, "   Post refresh request for bean : " + name);
                        this.postRequest(name, request);
                        break block16;
                    }
                    Trace.trace(TRACE_MASKF, "   Ignore refresh request for ObjectId : " + source);
                }
                catch (TaskletException e) {
                    Trace.trace(TRACE_MASKF, e);
                    this.abnormalTerminate();
                }
            } else {
                Trace.trace(TRACE_MASKF, "   Unknown event received ... ");
                new FrameworkLog(AttentionConstants.LOGINFO, 3, new HException("Unknown event")).log(FrameworkLogAttributes.INFO_LOG);
            }
        }
        Trace.trace(TRACE_MASKT, "<< propertyChange()");
    }

    void merge(PresentationTaskParms mergeData) {
        Trace.trace(TRACE_MASKT, ">> merge()");
        ObjectId[] newIDs = mergeData.getTargetIds();
        if (newIDs.length > 0) {
            AttentionRequest request = new AttentionRequest("SERVER", "ADD_TABS", null, newIDs);
            try {
                this.postRequest(this.frameBean.getBeanName(), request);
            }
            catch (TaskletException exception) {
                Trace.trace(TRACE_MASKF, exception);
                new FrameworkLog(AttentionConstants.LOGINFO, 3, new HException(exception)).log(FrameworkLogAttributes.INFO_LOG);
                this.abnormalTerminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<< merge()");
    }

    private void processInitialRequest(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> processInitialRequest()");
        this.primaryTasklet = AttentionTaskletManager.getAttentionTaskletManager().addAsPrimary(this);
        if (this.primaryTasklet) {
            PanelBean[] beans = this.createPanelBeans(this.getPresentationTaskParms().getTargetIds());
            if (beans.length > 0) {
                response.replace("com.ibm.hwmca.fw.attn.res.HwMessagesRes", "HwMessagesTPanel", this.frameBean, "HwMessagesTPane", "com.ibm.hwmca.fw.attn.res.HwMessagesRes", "HWMessagesPanel", beans);
                this.mom.addPropertyChangeListener(this);
            }
        } else {
            this.processTaskShutdown(request, response);
        }
        Trace.trace(TRACE_MASKT, "<< processInitialRequest() : Primary = " + this.primaryTasklet);
    }

    private void processServerRequest(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> processServerRequest()");
        String action = (String)request.getData("ACTION");
        if (action.equals("REFRESH")) {
            this.refreshInventory(request, response);
        } else if (action.equals("DETAILS")) {
            AttentionID attnID;
            ObjectId moID = (ObjectId)request.getData("OBJECTID");
            Attention attn = Attention.getAttention(moID, attnID = (AttentionID)request.getData("DATA"));
            if (attn != null) {
                DisplayAreaDescriptorDelegate delegate = this.createDetailsProcessor(attn);
                if (delegate != null) {
                    response.addPanelDescriptor(new DisplayAreaDescriptor[]{delegate});
                } else {
                    this.popupNoDetailsProcessorFound();
                    response.noAction();
                }
            } else {
                this.popupAttentionDeleted();
                response.noAction();
            }
        } else if (action.equals("ADD_TABS")) {
            this.addTabs(request, response);
        } else if (action.equals("REMOVE_TABS")) {
            this.removeTabs(request, response);
        } else {
            Trace.trace(TRACE_MASKF, "   Unknown server request");
            new FrameworkLog(AttentionConstants.LOGINFO, 3, new HException("Unknown request")).log(FrameworkLogAttributes.INFO_LOG);
        }
        Trace.trace(TRACE_MASKT, "<< processServerRequest()");
    }

    private void processDeleteRequest(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> processDeleteRequest()");
        ObjectId moID = (ObjectId)request.getData("OBJECTID");
        Object[] data = (Object[])request.getData("DATA");
        Trace.trace(TRACE_MASKT, "   Managed Object = " + moID.toString());
        ManagedObject mo = (ManagedObject)this.mom.get(moID);
        if (mo == null && moID.equals(this.hmc.getObjectId())) {
            mo = HMC.getHMC();
        }
        if (this.popupDeleteConfirmation().equals(CommonMsgInterface.OK_BUTTON) && mo != null) {
            ArrayList<Attention> attentions = new ArrayList<Attention>();
            for (int i = 0; i < data.length; ++i) {
                Attention attention = mo.getAttention((AttentionID)data[i]);
                if (attention == null) continue;
                attentions.add(attention);
            }
            mo.removeAttentions(attentions);
        }
        response.noAction();
        Trace.trace(TRACE_MASKT, "<< processDeleteRequest()");
    }

    private void processDetailsRequest(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> processDetailsRequest()");
        ObjectId moID = (ObjectId)request.getData("OBJECTID");
        ManagedObject mo = (ManagedObject)this.mom.get(moID);
        if (mo == null && moID.equals(this.hmc.getObjectId())) {
            mo = HMC.getHMC();
        }
        if (mo != null) {
            Object[] data = (Object[])request.getData("DATA");
            ArrayList<Attention> attns = new ArrayList<Attention>();
            for (int i = 0; i < data.length; ++i) {
                Attention attn = mo.getAttention((AttentionID)data[i]);
                if (attn == null) continue;
                attns.add(attn);
            }
            if (attns.size() > 0) {
                if (attns.size() > 1 && !this.popupDetailsConfirmation().equals(CommonMsgInterface.OK_BUTTON)) {
                    Trace.trace(TRACE_MASKF, "   Elected not to display details ...");
                    response.noAction();
                } else {
                    Trace.trace(TRACE_MASKF, "   Processing " + attns.size() + " request(s)...");
                    DisplayAreaDescriptorDelegate delegate = this.createDetailsProcessor((Attention)attns.remove(0));
                    if (delegate != null) {
                        response.addPanelDescriptor(new DisplayAreaDescriptor[]{delegate});
                    } else {
                        this.popupNoDetailsProcessorFound();
                        response.noAction();
                    }
                    Iterator iterator = attns.iterator();
                    while (iterator.hasNext()) {
                        Attention attn = (Attention)iterator.next();
                        AttentionRequest attnReq = new AttentionRequest("SERVER", "DETAILS", attn.getManagedObjectID(), attn.getAttentionID());
                        this.postRequest(this.frameBean.getBeanName(), attnReq);
                    }
                }
            } else {
                Trace.trace(TRACE_MASKF, "   No attentions received...");
                new FrameworkLog(AttentionConstants.LOGINFO, 3, new HException("No attentions")).log(FrameworkLogAttributes.INFO_LOG);
                response.noAction();
            }
        } else {
            Trace.trace(TRACE_MASKF, "   Managed Object not found...");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<< processDetailsRequest()");
    }

    private void refreshInventory(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> refreshInventory()");
        ObjectId moID = (ObjectId)request.getData("OBJECTID");
        ManagedObject mo = (ManagedObject)this.mom.get(moID);
        if (mo == null && moID.equals(this.hmc.getObjectId())) {
            mo = HMC.getHMC();
        }
        if (mo != null) {
            response.update(mo.getUIInfo().getName(), this.getCoreInfos(mo));
        } else {
            Trace.trace(TRACE_MASKF, "   Managed Object not found...");
            response.noAction();
        }
    }

    private void addTabs(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> addTabs()");
        ObjectId[] moIDs = (ObjectId[])request.getData("DATA");
        if (moIDs.length > 0) {
            HwMessagesBean[] beans = this.createPanelBeans(moIDs);
            DisplayAreaDescriptor[] descriptors = new DisplayAreaDescriptor[beans.length];
            for (int i = 0; i < beans.length; ++i) {
                Trace.trace(TRACE_MASKF, "   Adding tab for Bean " + beans[i].getBeanName());
                descriptors[i] = new DisplayAreaDescriptorData("com.ibm.hwmca.fw.attn.res.HwMessagesRes", "HWMessagesPanel", beans[i], null, null, "HwMessagesTPane");
            }
            response.addPanelDescriptor(descriptors);
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<< addTabs()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTabs(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> removeTabs()");
        ArrayList remove = null;
        Object object = this.pendingTabRemovalsLock;
        synchronized (object) {
            remove = this.pendingTabRemovals;
            this.pendingTabRemovals = new ArrayList();
        }
        if (remove.size() > 0) {
            ArrayList<String> targets = new ArrayList<String>();
            boolean empty = false;
            Iterator iterator = remove.iterator();
            while (iterator.hasNext()) {
                ObjectId moID = (ObjectId)iterator.next();
                Object object2 = this.inventoryLock;
                synchronized (object2) {
                    if (this.inventory.containsKey(moID) && !moID.equals(HMC.getHMC().getObjectId())) {
                        Trace.trace(TRACE_MASKD, "   Removing tab : " + this.inventory.get(moID));
                        String name = "HwMessagesTPane." + (String)this.inventory.get(moID);
                        targets.add(name);
                        this.inventory.remove(moID);
                        if (this.inventory.isEmpty()) {
                            empty = true;
                            break;
                        }
                    }
                }
            }
            if (targets.size() > 0 && !empty) {
                Trace.trace(TRACE_MASKF, "   Removing " + targets.size() + " tab(s)...");
                response.removePanelConstruct(targets.toArray(new String[targets.size()]));
            } else if (empty) {
                Trace.trace(TRACE_MASKF, "   Removing last tab ... terminating tasklet ...");
                this.processTaskShutdown(request, response);
            } else {
                Trace.trace(TRACE_MASKF, "   No tabs to remove...");
                response.noAction();
            }
        } else {
            Trace.trace(TRACE_MASKF, "   No tabs to remove...");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<< removeTabs()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HwMessagesBean[] createPanelBeans(ObjectId[] ids) {
        Trace.trace(TRACE_MASKT, ">> createPanelBeans()");
        ArrayList<HwMessagesBean> beans = new ArrayList<HwMessagesBean>();
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                ManagedObject mo = (ManagedObject)this.mom.get(ids[i]);
                if (mo == null && ids[i].equals(this.hmc.getObjectId())) {
                    mo = this.hmc;
                }
                if (mo == null) continue;
                String beanName = mo.getUIInfo().getName();
                boolean newBean = false;
                Object object = this.inventoryLock;
                synchronized (object) {
                    boolean bl = newBean = !this.inventory.containsKey(ids[i]);
                    if (newBean) {
                        this.inventory.put(ids[i], beanName);
                    }
                }
                if (!newBean) continue;
                HwMessagesBean bean = new HwMessagesBean(ids[i]);
                bean.setBeanName(beanName);
                bean.setDisplayableBeanName(new LocalizableText(beanName));
                bean.refreshTableData(this.getCoreInfos(mo));
                beans.add(bean);
                Trace.trace(TRACE_MASKT, "   Adding tab for " + beanName);
                mo.addPropertyChangeListener("Attentions", this);
            }
        }
        Trace.trace(TRACE_MASKT, "<< createPanelBeans() : Created " + beans.size() + " bean(s)...");
        return beans.toArray(new HwMessagesBean[beans.size()]);
    }

    private ArrayList getCoreInfos(ManagedObject mo) {
        ArrayList<AttentionCoreInfo> infos = new ArrayList<AttentionCoreInfo>();
        Iterator iterator = mo.getAttentions().iterator();
        while (iterator.hasNext()) {
            infos.add(((Attention)iterator.next()).getCoreInfo());
        }
        return infos;
    }

    private DisplayAreaDescriptorDelegate createDetailsProcessor(Attention attn) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> createDetailsProcessor()");
        DisplayAreaDescriptorDelegate delegate = null;
        String className = attn.getAttentionDetailsClassName();
        if (className != null) {
            HashMap<String, Persistable> initData = new HashMap<String, Persistable>();
            initData.put("OBJECT_ID", attn.getManagedObjectID());
            initData.put("ATTENTION_ID", attn.getAttentionID());
            delegate = new DisplayAreaDescriptorDelegate(className, initData);
            delegate.setMountPoint(null);
        }
        Trace.trace(TRACE_MASKT, "<< createDetailsProcessor() : " + delegate);
        return delegate;
    }

    private void processTaskShutdown(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> processTaskShutdown()");
        this.cleanup();
        response.terminate();
        Trace.trace(TRACE_MASKT, "<< processTaskShutdown()");
    }

    private void cleanup() {
        Trace.trace(TRACE_MASKT, ">> cleanup()");
        Iterator iterator = this.inventory.keySet().iterator();
        while (iterator.hasNext()) {
            ObjectId moID = (ObjectId)iterator.next();
            ManagedObject mo = (ManagedObject)this.mom.get(moID);
            if (mo != null) {
                mo.removePropertyChangeListener(this);
                continue;
            }
            if (!moID.equals(this.hmc.getObjectId())) continue;
            this.hmc.removePropertyChangeListener(this);
        }
        this.mom.removePropertyChangeListener(this);
        if (this.primaryTasklet) {
            AttentionTaskletManager.getAttentionTaskletManager().removeAsPrimary(this);
        }
        Trace.trace(TRACE_MASKT, "<< cleanup()");
    }

    public LocalizableText popupDeleteConfirmation() throws TaskletException {
        return this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.fw.attn.res.message", "EMP.MSG.TITLE"), new MessageText("com.ibm.hwmca.fw.attn.res.message", "EMP.DELETE.SELECTED.TEXT"), MsgType.WARNING_MESSAGE, null);
    }

    public LocalizableText popupDetailsConfirmation() throws TaskletException {
        return this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.fw.attn.res.message", "EMP.MSG.TITLE"), new MessageText("com.ibm.hwmca.fw.attn.res.message", "EMP.DETAILS.DISPLAY.TEXT"), MsgType.WARNING_MESSAGE, null);
    }

    public LocalizableText popupNoDetailsProcessorFound() throws TaskletException {
        return this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.fw.attn.res.message", "EMP.MSG.TITLE"), new MessageText("com.ibm.hwmca.fw.attn.res.message", "EMP.NO.DETAILS.EXIST.TEXT"), MsgType.WARNING_MESSAGE, null);
    }

    public LocalizableText popupAttentionDeleted() throws TaskletException {
        return this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.fw.attn.res.message", "EMP.MSG.TITLE"), new MessageText("com.ibm.hwmca.fw.attn.res.message", "EMP.MESSAGE.DELETED.TEXT"), MsgType.WARNING_MESSAGE, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FrameBean
    extends PanelBean {
        public FrameBean(String name) {
            this.setBeanName(name);
            this.setDisplayableBeanName(new LocalizableText(this.getBeanName()));
        }

        public void panelAction(TaskActionEvent event) {
            Trace.trace(AttentionPanelTasklet.TRACE_MASKT, ">> panelAction() : \n   Bean Name     : " + this.getBeanName() + "\n   CurrentElement: " + event.getCurrentElement() + "\n   ElementName   : " + event.getElementName() + "\n   ActionCommand : " + event.getActionCommand());
            if (event.getActionCommand().equals("CANCEL")) {
                this.dispose();
            }
            Trace.trace(AttentionPanelTasklet.TRACE_MASKT, "<< panelAction()");
        }

        public Capabilities getCapabilities() {
            return null;
        }

        public void verifyChanges() throws IllegalUserDataException {
        }

        public void save() {
        }

        public void load() {
        }
    }
}

